/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.datagen.bclib.preset;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.WorldPresetTags;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import org.betterx.bclib.api.v2.generator.BCLChunkGenerator;
import org.betterx.bclib.api.v2.generator.config.BCLEndBiomeSourceConfig;
import org.betterx.bclib.api.v2.generator.config.BCLNetherBiomeSourceConfig;
import org.betterx.bclib.api.v2.levelgen.LevelGenUtil;
import org.betterx.bclib.registry.PresetsRegistry;
import org.betterx.worlds.together.levelgen.WorldGenUtil;
import org.betterx.worlds.together.worldPreset.TogetherWorldPreset;
import org.betterx.worlds.together.worldPreset.WorldPresets;

public class WorldPresetDataProvider
extends FabricTagProvider<WorldPreset> {
    public WorldPresetDataProvider(FabricDataOutput output, CompletableFuture<HolderLookup.Provider> registriesFuture) {
        super(output, Registries.f_256729_, registriesFuture);
    }

    public static void bootstrap(BootstapContext<WorldPreset> bootstrapContext) {
        WorldPresets.BootstrapData ctx = new WorldPresets.BootstrapData(bootstrapContext);
        bootstrapContext.m_255272_(PresetsRegistry.BCL_WORLD, (Object)WorldPresetDataProvider.createNormal(ctx));
        bootstrapContext.m_255272_(PresetsRegistry.BCL_WORLD_LARGE, (Object)WorldPresetDataProvider.createLarge(ctx));
        bootstrapContext.m_255272_(PresetsRegistry.BCL_WORLD_AMPLIFIED, (Object)WorldPresetDataProvider.createAmplified(ctx));
        bootstrapContext.m_255272_(PresetsRegistry.BCL_WORLD_17, (Object)WorldPresetDataProvider.createLegacy(ctx));
    }

    private static WorldPreset createLegacy(WorldPresets.BootstrapData ctx) {
        return WorldPresetDataProvider.buildPreset(ctx.overworldStem, ctx.netherContext, BCLNetherBiomeSourceConfig.MINECRAFT_17, ctx.endContext, BCLEndBiomeSourceConfig.MINECRAFT_17);
    }

    private static WorldPreset createAmplified(WorldPresets.BootstrapData ctx) {
        Holder.Reference amplifiedBiomeGenerator = ctx.noiseSettings.m_255043_(NoiseGeneratorSettings.f_64433_);
        WorldGenUtil.Context amplifiedNetherContext = new WorldGenUtil.Context((Holder<DimensionType>)ctx.netherContext.dimension, (HolderGetter<StructureSet>)ctx.netherContext.structureSets, (Holder<NoiseGeneratorSettings>)ctx.noiseSettings.m_255043_(BCLChunkGenerator.AMPLIFIED_NETHER));
        return WorldPresetDataProvider.buildPreset(ctx.makeNoiseBasedOverworld(ctx.overworldStem.f_63976_().m_62218_(), (Holder<NoiseGeneratorSettings>)amplifiedBiomeGenerator), amplifiedNetherContext, BCLNetherBiomeSourceConfig.MINECRAFT_18_AMPLIFIED, ctx.endContext, BCLEndBiomeSourceConfig.MINECRAFT_20_AMPLIFIED);
    }

    private static WorldPreset createLarge(WorldPresets.BootstrapData ctx) {
        Holder.Reference largeBiomeGenerator = ctx.noiseSettings.m_255043_(NoiseGeneratorSettings.f_188869_);
        return WorldPresetDataProvider.buildPreset(ctx.makeNoiseBasedOverworld(ctx.overworldStem.f_63976_().m_62218_(), (Holder<NoiseGeneratorSettings>)largeBiomeGenerator), ctx.netherContext, BCLNetherBiomeSourceConfig.MINECRAFT_18_LARGE, ctx.endContext, BCLEndBiomeSourceConfig.MINECRAFT_20_LARGE);
    }

    private static WorldPreset createNormal(WorldPresets.BootstrapData ctx) {
        return WorldPresetDataProvider.buildPreset(ctx.overworldStem, ctx.netherContext, BCLNetherBiomeSourceConfig.DEFAULT, ctx.endContext, BCLEndBiomeSourceConfig.DEFAULT);
    }

    private static TogetherWorldPreset buildPreset(LevelStem overworldStem, WorldGenUtil.Context netherContext, BCLNetherBiomeSourceConfig netherConfig, WorldGenUtil.Context endContext, BCLEndBiomeSourceConfig endConfig) {
        return new TogetherWorldPreset(WorldPresetDataProvider.buildDimensionMap(overworldStem, netherContext, netherConfig, endContext, endConfig), 1000);
    }

    public static Map<ResourceKey<LevelStem>, LevelStem> buildDimensionMap(LevelStem overworldStem, WorldGenUtil.Context netherContext, BCLNetherBiomeSourceConfig netherConfig, WorldGenUtil.Context endContext, BCLEndBiomeSourceConfig endConfig) {
        return Map.of(LevelStem.f_63971_, overworldStem, LevelStem.f_63972_, LevelGenUtil.getBCLNetherLevelStem(netherContext, netherConfig), LevelStem.f_63973_, LevelGenUtil.getBCLEndLevelStem(endContext, endConfig));
    }

    protected void m_6577_(HolderLookup.Provider arg) {
        FabricTagProvider.FabricTagBuilder builder = this.getOrCreateTagBuilder(WorldPresetTags.f_216053_);
        builder.add(PresetsRegistry.BCL_WORLD);
        builder.add(PresetsRegistry.BCL_WORLD_AMPLIFIED);
        builder.add(PresetsRegistry.BCL_WORLD_LARGE);
    }
}

